/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.tinker;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.NumberBlock;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;
import com.ardublock.translator.block.tinker.TinkerInputPortBlock;

public class TinkerButtonBlock
extends TranslatorBlock {
    public TinkerButtonBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
        translator.addHeaderFile("TinkerKit.h");
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        TranslatorBlock translatorBlock = this.getRequiredTranslatorBlockAtSocket(0);
        if (translatorBlock instanceof TinkerInputPortBlock) {
            String tkButtonName = "tkButton_" + translatorBlock.toCode();
            this.translator.addDefinitionCommand("TKButton " + tkButtonName + "(" + translatorBlock.toCode() + ");");
            return tkButtonName + ".read()";
        }
        if (translatorBlock instanceof NumberBlock) {
            String number = translatorBlock.toCode();
            String setupCode = "pinMode( " + number + " , INPUT);";
            this.translator.addSetupCommand(setupCode);
            String ret = "digitalRead( ";
            ret = ret + number;
            ret = ret + ")";
            return this.codePrefix + ret + this.codeSuffix;
        }
        this.translator.addDefinitionCommand("boolean __ardublockDigitalRead(int pinNumber)\n{\npinMode(pinNumber, INPUT);\nreturn digitalRead(pinNumber);\n}\n\n");
        String ret = "__ardublockDigitalRead(";
        ret = ret + translatorBlock.toCode();
        ret = ret + ")";
        return this.codePrefix + ret + this.codeSuffix;
    }
}

