/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks;

import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.rendering.BlockShapeUtil;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BlockConnectorShape {
    public static final float DATA_PLUG_HEIGHT = 24.0f;
    public static final float NORMAL_DATA_PLUG_WIDTH = 8.0f;
    public static final float POLYMORPHIC_DATA_PLUG_WIDTH = 8.0f;
    public static final float CONTROL_PLUG_WIDTH = 14.0f;
    public static final float CONTROL_PLUG_HEIGHT = 4.0f;
    public static final float COMMAND_INPUT_BAR_WIDTH = 17.0f;
    public static final float COMMAND_INPUT_BAR_HEIGHT = 5.0f;
    public static final float DEFAULT_COMMAND_INPUT_HEIGHT = 24.0f;
    private Point2D startPoint;
    private GeneralPath currentConnectorPath;
    private static HashMap<String, Integer> SHAPE_MAPPINGS = new HashMap();
    private static String COMMAND_SHAPE_NAME;
    public static final int TRIANGLE_1 = 1;
    public static final int TRIANGLE_2 = 2;
    public static final int TRIANGLE_3 = 3;
    public static final int CIRCLE_1 = 4;
    public static final int CIRCLE_2 = 5;
    public static final int CIRCLE_3 = 6;
    public static final int SQUARE_1 = 7;
    public static final int SQUARE_2 = 8;
    public static final int SQUARE_3 = 9;
    public static final int POLYMORPHIC_1 = 10;
    public static final int POLYMORPHIC_2 = 11;
    public static final int POLYMORPHIC_3 = 12;
    public static final int PROC_PARAM = 13;
    public static final int COMMAND = 14;
    public static final boolean DEBUG_MODE = false;

    private void addDebugConnectionShapeMappings() {
        BlockConnectorShape.addConnenctionShapeMapping("number", 1);
        BlockConnectorShape.addConnenctionShapeMapping("number-list", 2);
        BlockConnectorShape.addConnenctionShapeMapping("number-inv", 3);
        BlockConnectorShape.addConnenctionShapeMapping("boolean", 4);
        BlockConnectorShape.addConnenctionShapeMapping("boolean-list", 5);
        BlockConnectorShape.addConnenctionShapeMapping("boolean-inv", 6);
        BlockConnectorShape.addConnenctionShapeMapping("string", 7);
        BlockConnectorShape.addConnenctionShapeMapping("string-list", 8);
        BlockConnectorShape.addConnenctionShapeMapping("string-inv", 9);
        BlockConnectorShape.addConnenctionShapeMapping("poly", 10);
        BlockConnectorShape.addConnenctionShapeMapping("poly-list", 11);
        BlockConnectorShape.addConnenctionShapeMapping("poly-inv", 12);
        BlockConnectorShape.addConnenctionShapeMapping("proc-param", 13);
        BlockConnectorShape.addConnenctionShapeMapping("cmd", 14);
    }

    public static void addConnenctionShapeMapping(String shapeName, int integer) {
        SHAPE_MAPPINGS.put(shapeName, integer);
        if (integer == 14) {
            COMMAND_SHAPE_NAME = shapeName;
        }
    }

    public static void resetConnectorShapeMappings() {
        SHAPE_MAPPINGS.clear();
    }

    public static int getConnenctionShapeMapping(String shapeName) {
        if (SHAPE_MAPPINGS.get(shapeName) == null) {
            assert (false) : "Unknown Connection Type: " + shapeName;
            return -1;
        }
        return SHAPE_MAPPINGS.get(shapeName);
    }

    public static Dimension getConnectorDimensions(BlockConnector blockConnector) {
        int mappedValue = BlockConnectorShape.getConnenctionShapeMapping(blockConnector.getKind());
        assert (mappedValue != -1) : "Block Connector is not mapped: " + blockConnector;
        if (mappedValue == 10 || mappedValue == 11 || mappedValue == 12) {
            return new Dimension(8, 24);
        }
        return new Dimension(8, 24);
    }

    public Point2D addControlConnectorShape(GeneralPath blockPath, boolean appendRight) {
        return this.addControlConnectorShape(blockPath, 7.0f, appendRight);
    }

    public Point2D addControlConnectorShape(GeneralPath blockPath, float distanceToCenter, boolean appendRight) {
        this.startPoint = blockPath.getCurrentPoint();
        Point2D.Float socketPoint = new Point2D.Float((float)this.startPoint.getX() + (appendRight ? distanceToCenter : -distanceToCenter), (float)this.startPoint.getY());
        this.currentConnectorPath = blockPath;
        if (appendRight) {
            this._lineTo(distanceToCenter - 7.0f, 0.0f);
            this.startPoint = blockPath.getCurrentPoint();
            this._curveTo(7.0f, 5.3333335f, 7.0f, 5.3333335f, 14.0f, 0.0f);
        } else {
            this._lineTo(-distanceToCenter + 7.0f, 0.0f);
            this.startPoint = blockPath.getCurrentPoint();
            this._curveTo(-7.0f, 5.3333335f, -7.0f, 5.3333335f, -14.0f, 0.0f);
        }
        this.currentConnectorPath = null;
        return socketPoint;
    }

    public Point2D addCommandSocket(GeneralPath blockPath, int commandSocketHeight) {
        BlockShapeUtil.lineToRelative(blockPath, 17.0f, 0.0f);
        BlockShapeUtil.lineToRelative(blockPath, 0.0f, 5.0f);
        Point2D socketPoint = this.addControlConnectorShape(blockPath, false);
        BlockShapeUtil.cornerTo(blockPath, new Point2D.Float((float)blockPath.getCurrentPoint().getX() - 17.0f + 3.0f, (float)blockPath.getCurrentPoint().getY()), new Point2D.Float((float)blockPath.getCurrentPoint().getX() - 17.0f + 3.0f, (float)blockPath.getCurrentPoint().getY() + 3.0f), 3.0f);
        BlockShapeUtil.lineToRelative(blockPath, 0.0f, commandSocketHeight);
        BlockShapeUtil.cornerTo(blockPath, new Point2D.Float((float)blockPath.getCurrentPoint().getX(), (float)blockPath.getCurrentPoint().getY() + 3.0f), new Point2D.Float((float)blockPath.getCurrentPoint().getX() + 3.0f, (float)blockPath.getCurrentPoint().getY() + 3.0f), 3.0f);
        BlockShapeUtil.lineToRelative(blockPath, 7.0f, 0.0f);
        return socketPoint;
    }

    public Point2D addDataSocket(GeneralPath blockPath, String connectionShape, boolean onRightSide) {
        return this.addDataConnection(blockPath, connectionShape, true, !onRightSide);
    }

    public Point2D addDataSocketUp(GeneralPath blockPath, String connectionShape, boolean onRightSide) {
        return this.addDataConnection(blockPath, connectionShape, false, !onRightSide);
    }

    public Point2D addDataPlug(GeneralPath blockPath, String connectionShape, boolean onRightSide) {
        return this.addDataConnection(blockPath, connectionShape, true, onRightSide);
    }

    public Point2D addDataPlugUp(GeneralPath blockPath, String connectionShape, boolean onRightSide) {
        return this.addDataConnection(blockPath, connectionShape, false, onRightSide);
    }

    private Point2D addDataConnection(GeneralPath blockPath, String connectionShape, boolean startFromTop, boolean convexRight) {
        int connectionShapeInt = BlockConnectorShape.getConnenctionShapeMapping(connectionShape);
        this.startPoint = blockPath.getCurrentPoint();
        float xStart = (float)this.startPoint.getX();
        float yStart = (float)this.startPoint.getY();
        this.currentConnectorPath = new GeneralPath();
        this.currentConnectorPath.moveTo(xStart, yStart);
        Point2D.Float socketPoint = new Point2D.Float((float)this.startPoint.getX(), startFromTop ? (float)this.startPoint.getY() + 12.0f : (float)this.startPoint.getY() - 12.0f);
        switch (connectionShapeInt) {
            case 1: {
                this._lineTo(8.0f, 12.0f);
                this._lineTo(0.0f, 24.0f);
                break;
            }
            case 2: {
                this._lineTo(8.0f, 6.0f);
                this._lineTo(0.0f, 12.0f);
                this._lineTo(8.0f, 18.0f);
                this._lineTo(0.0f, 24.0f);
                break;
            }
            case 3: {
                this._lineTo(8.0f, 6.0f);
                this._lineTo(0.0f, 12.0f);
                this._lineTo(-8.0f, 18.0f);
                this._lineTo(0.0f, 24.0f);
                break;
            }
            case 4: {
                this._curveTo(10.666667f, 0.0f, 10.666667f, 24.0f, 0.0f, 24.0f);
                break;
            }
            case 5: {
                this._curveTo(8.0f, 0.0f, 8.0f, 6.0f, 4.0f, 12.0f);
                this._curveTo(8.0f, 18.0f, 8.0f, 24.0f, 0.0f, 24.0f);
                break;
            }
            case 6: {
                this._curveTo(8.0f, 0.0f, 8.0f, 6.0f, 4.0f, 12.0f);
                this._curveTo(-8.0f, 18.0f, -8.0f, 24.0f, 0.0f, 24.0f);
                break;
            }
            case 7: {
                this._lineTo(0.0f, 3.6000001f);
                this._lineTo(8.0f, 3.6000001f);
                this._lineTo(8.0f, 20.400002f);
                this._lineTo(0.0f, 20.400002f);
                this._lineTo(0.0f, 24.0f);
                break;
            }
            case 8: {
                this._lineTo(0.0f, 3.6000001f);
                this._lineTo(8.0f, 3.6000001f);
                this._lineTo(8.0f, 10.799999f);
                this._lineTo(0.0f, 10.799999f);
                this._lineTo(0.0f, 13.200001f);
                this._lineTo(8.0f, 13.200001f);
                this._lineTo(8.0f, 20.400002f);
                this._lineTo(0.0f, 20.400002f);
                this._lineTo(0.0f, 24.0f);
                break;
            }
            case 9: {
                this._lineTo(0.0f, 3.6000001f);
                this._lineTo(8.0f, 3.6000001f);
                this._lineTo(8.0f, 12.0f);
                this._lineTo(-8.0f, 12.0f);
                this._lineTo(-8.0f, 20.400002f);
                this._lineTo(0.0f, 20.400002f);
                this._lineTo(0.0f, 24.0f);
                break;
            }
            case 10: {
                this._curveTo(0.0f, 8.0f, 2.6666667f, 8.0f, 4.0f, 6.0f);
                this._curveTo(5.3333335f, 4.0f, 8.0f, 4.0f, 8.0f, 12.0f);
                this._curveTo(8.0f, 20.0f, 5.3333335f, 20.0f, 4.0f, 18.0f);
                this._curveTo(2.6666667f, 16.0f, 0.0f, 16.0f, 0.0f, 24.0f);
                break;
            }
            case 11: {
                this._curveTo(0.0f, 4.0f, 2.6666667f, 4.0f, 4.0f, 3.0f);
                this._curveTo(5.3333335f, 2.0f, 8.0f, 2.0f, 8.0f, 6.0f);
                this._curveTo(8.0f, 10.0f, 5.3333335f, 10.0f, 4.0f, 9.0f);
                this._curveTo(2.6666667f, 8.0f, 0.0f, 8.0f, 0.0f, 12.0f);
                this._curveTo(0.0f, 16.0f, 2.6666667f, 16.0f, 4.0f, 15.0f);
                this._curveTo(5.3333335f, 14.0f, 8.0f, 14.0f, 8.0f, 18.0f);
                this._curveTo(8.0f, 22.0f, 5.3333335f, 22.0f, 4.0f, 21.0f);
                this._curveTo(2.6666667f, 20.0f, 0.0f, 20.0f, 0.0f, 24.0f);
                break;
            }
            case 12: {
                this._lineTo(2.6666667f, 3.0f);
                this._lineTo(4.0f, 0.6f);
                this._lineTo(6.0f, 3.0f);
                this._curveTo(8.888889f, 3.6000001f, 8.888889f, 8.4f, 6.0f, 9.0f);
                this._lineTo(4.0f, 11.4f);
                this._lineTo(2.6666667f, 9.0f);
                this._lineTo(0.0f, 12.0f);
                this._lineTo(-2.6666667f, 15.0f);
                this._lineTo(-4.0f, 12.6f);
                this._lineTo(-6.0f, 15.0f);
                this._curveTo(-8.888889f, 15.6f, -8.888889f, 20.4f, -6.0f, 21.0f);
                this._lineTo(-4.0f, 23.4f);
                this._lineTo(-2.6666667f, 21.0f);
                this._lineTo(0.0f, 24.0f);
                break;
            }
            case 13: {
                this._lineTo(0.0f, 6.0f);
                this._lineTo(8.0f, 6.0f);
                this._lineTo(8.0f, 18.0f);
                this._lineTo(0.0f, 18.0f);
                this._lineTo(0.0f, 24.0f);
                break;
            }
        }
        if (!startFromTop || !convexRight) {
            this.transformGeneralPath(this.currentConnectorPath, !convexRight, !startFromTop);
        }
        blockPath.append(this.currentConnectorPath, true);
        this.currentConnectorPath = null;
        return socketPoint;
    }

    private void _lineTo(float x, float y) {
        this.currentConnectorPath.lineTo(x + (float)this.startPoint.getX(), y + (float)this.startPoint.getY());
    }

    private void _curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.currentConnectorPath.curveTo(x1 + (float)this.startPoint.getX(), y1 + (float)this.startPoint.getY(), x2 + (float)this.startPoint.getX(), y2 + (float)this.startPoint.getY(), x3 + (float)this.startPoint.getX(), y3 + (float)this.startPoint.getY());
    }

    private void transformGeneralPath(GeneralPath gp, boolean horzFlip, boolean vertFlip) {
        double yTranslate;
        int yScale;
        double xTranslate;
        int xScale;
        if (horzFlip) {
            xScale = -1;
            xTranslate = 2.0 * this.startPoint.getX();
        } else {
            xScale = 1;
            xTranslate = 0.0;
        }
        if (vertFlip) {
            yScale = -1;
            yTranslate = 2.0 * this.startPoint.getY();
        } else {
            yScale = 1;
            yTranslate = 0.0;
        }
        AffineTransform scale = AffineTransform.getScaleInstance(xScale, yScale);
        AffineTransform transform = AffineTransform.getTranslateInstance(xTranslate, yTranslate);
        gp.transform(scale);
        gp.transform(transform);
    }

    public static void loadBlockConnectorShapes(Element root) {
        Pattern attrExtractor = Pattern.compile("\"(.*)\"");
        NodeList drawerNodes = root.getElementsByTagName("BlockConnectorShape");
        int i = 0;
        while (i < drawerNodes.getLength()) {
            Node drawerNode = drawerNodes.item(i);
            if (drawerNode.getNodeName().equals("BlockConnectorShape")) {
                String shapeType = null;
                String shapeNumber = null;
                Matcher nameMatcher = attrExtractor.matcher(drawerNode.getAttributes().getNamedItem("shape-type").toString());
                if (nameMatcher.find()) {
                    shapeType = nameMatcher.group(1);
                }
                if ((nameMatcher = attrExtractor.matcher(drawerNode.getAttributes().getNamedItem("shape-number").toString())).find()) {
                    shapeNumber = nameMatcher.group(1);
                }
                if (shapeType != null && shapeNumber != null) {
                    BlockConnectorShape.addConnenctionShapeMapping(shapeType, Integer.parseInt(shapeNumber));
                }
            }
            ++i;
        }
    }

    public static boolean isCommandConnector(BlockConnector connector) {
        return BlockConnectorShape.getConnenctionShapeMapping(connector.getKind()) == 14;
    }

    public static String getCommandShapeName() {
        return COMMAND_SHAPE_NAME;
    }
}

