/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.SliderBlueprint;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import javax.swing.JPanel;

public class CSlider
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 328149080257L;
    public static String VALUE_CHANGED = "VALUE_CHANGED";
    static final RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private int value;
    private int left;
    private int right;
    private final Color leadingColor;
    private final Color trailingColor;
    private final Color thumbColor;
    private final SliderBlueprint blueprint;
    private final float trackThickness;
    private int offset = 0;
    private int thumbStart = 0;
    private boolean setTicks = false;
    private int tickNumber = 1;
    private boolean startMark = false;
    private String startMarkLabel = "";

    public CSlider() {
        this(0, 100, 50, 0.2f, Color.blue, Color.black, Color.gray, false, 0, false, "");
    }

    public CSlider(int left, int right, int value) {
        this(left, right, value, 0.2f, Color.blue, Color.black, Color.gray, false, 0, false, "");
    }

    public CSlider(int left, int right, int value, boolean setTicks, int numTicks) {
        this(left, right, value, 0.2f, Color.blue, Color.black, Color.gray, setTicks, numTicks, false, "");
    }

    public CSlider(int left, int right, int value, boolean setTicks, int numTicks, boolean startMark, String startMarkLabel) {
        this(left, right, value, 0.2f, Color.blue, Color.black, Color.gray, setTicks, numTicks, startMark, startMarkLabel);
    }

    public CSlider(int left, int right, int value, float thickness, Color leadingTrackColor, Color trailingTrackColor, Color thumbColor, boolean setTicks, int numTicks, boolean startMark, String startMarkLabel) {
        super(null);
        this.startMark = startMark;
        this.startMarkLabel = startMarkLabel;
        this.thumbStart = value;
        this.setTicks = setTicks;
        this.tickNumber = numTicks;
        this.setSize(100, 25);
        this.setOpaque(false);
        this.setCursor(new Cursor(12));
        this.leadingColor = leadingTrackColor;
        this.trailingColor = trailingTrackColor;
        this.thumbColor = thumbColor;
        this.left = left;
        this.value = value;
        this.right = right;
        this.trackThickness = thickness;
        this.blueprint = new SliderBlueprint();
        this.addActionListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void addActionListener(CSlider slider) {
        this.repaint();
    }

    public int getRight() {
        return this.right;
    }

    public int getLeft() {
        return this.left;
    }

    public int getValue() {
        return this.value;
    }

    public void setRight(int right) {
        this.right = right;
        if (this.value < Math.min(this.left, this.right)) {
            this.setValue(Math.min(this.left, this.right));
        } else if (this.value > Math.max(this.left, this.right)) {
            this.setValue(Math.max(this.left, this.right));
        }
        this.repaint();
    }

    public void setLeft(int left) {
        this.left = left;
        if (this.value < Math.min(this.left, this.right)) {
            this.setValue(Math.min(this.left, this.right));
        } else if (this.value > Math.max(this.left, this.right)) {
            this.setValue(Math.max(this.left, this.right));
        }
        this.repaint();
    }

    public void setValue(int val) {
        int oldvalue = this.value;
        this.value = val < Math.min(this.left, this.right) ? Math.min(this.left, this.right) : (val > Math.max(this.left, this.right) ? Math.max(this.left, this.right) : val);
        this.repaint();
        this.firePropertyChange(VALUE_CHANGED, oldvalue, this.value);
    }

    public Shape reformLeadingTrack(SliderBlueprint blueprint) {
        GeneralPath shape = new GeneralPath();
        shape.moveTo(blueprint.closeTrackEdgeLeft, blueprint.trackTop);
        shape.lineTo(blueprint.thumbCenter, blueprint.trackTop);
        shape.lineTo(blueprint.thumbCenter, blueprint.trackBottom);
        shape.lineTo(blueprint.closeTrackEdgeLeft, blueprint.trackBottom);
        shape.curveTo(blueprint.farTrackEdgeLeft, blueprint.trackBottom, blueprint.farTrackEdgeLeft, blueprint.trackTop, blueprint.closeTrackEdgeLeft, blueprint.trackTop);
        shape.closePath();
        return shape;
    }

    public Shape reformTrailingTrack(SliderBlueprint blueprint) {
        GeneralPath shape = new GeneralPath();
        shape.moveTo(blueprint.thumbCenter, blueprint.trackTop);
        shape.lineTo(blueprint.closeTrackEdgeRight, blueprint.trackTop);
        shape.curveTo(blueprint.farTrackEdgeRight, blueprint.trackTop, blueprint.farTrackEdgeRight, blueprint.trackBottom, blueprint.closeTrackEdgeRight, blueprint.trackBottom);
        shape.lineTo(blueprint.thumbCenter, blueprint.trackBottom);
        shape.lineTo(blueprint.thumbCenter, blueprint.trackTop);
        shape.closePath();
        return shape;
    }

    public Shape reformThumb(SliderBlueprint blueprint, int diameter) {
        return new Ellipse2D.Double(blueprint.thumbCenter - diameter / 2, blueprint.trackMiddleY - diameter / 2, diameter, diameter);
    }

    public Shape reformTicks(SliderBlueprint blueprint) {
        GeneralPath ticks = new GeneralPath();
        int count = 0;
        float position = blueprint.closeTrackEdgeLeft;
        float interval = (float)(blueprint.closeTrackEdgeRight - blueprint.closeTrackEdgeLeft) / (float)this.tickNumber;
        while (count < this.tickNumber + 1) {
            ticks.moveTo((int)position, blueprint.trackTop);
            ticks.lineTo((int)position, blueprint.trackBottom);
            position += interval;
            ++count;
        }
        ticks.closePath();
        return ticks;
    }

    public void reformBlueprint(SliderBlueprint blueprint, int width, int height, int girth, int thumbX) {
        blueprint.farTrackEdgeLeft = height / 2 - girth / 2;
        blueprint.closeTrackEdgeLeft = height / 2;
        blueprint.thumbCenter = thumbX;
        blueprint.closeTrackEdgeRight = width - height / 2;
        blueprint.farTrackEdgeRight = width - height / 2 + girth / 2;
        blueprint.trackTop = height / 2 - girth / 2;
        blueprint.trackMiddleY = height / 2;
        blueprint.trackBottom = height / 2 + girth / 2;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.addRenderingHints(renderingHints);
        int thumbX = this.getThumbX();
        this.reformBlueprint(this.blueprint, this.getWidth(), this.getHeight(), (int)(this.trackThickness * (float)this.getHeight()), thumbX);
        Shape leading = this.reformLeadingTrack(this.blueprint);
        Shape trailing = this.reformTrailingTrack(this.blueprint);
        Shape thumb = this.reformThumb(this.blueprint, this.getHeight() / 2);
        Shape miniThumb = this.reformThumb(this.blueprint, this.getHeight() / 4);
        g2.setPaint(new GradientPaint(0.0f, this.blueprint.trackTop, this.leadingColor, 0.0f, this.blueprint.trackBottom, Color.white, false));
        g2.fill(leading);
        g2.setPaint(new GradientPaint(0.0f, this.blueprint.trackTop, this.trailingColor, 0.0f, this.blueprint.trackBottom, Color.white, false));
        g2.fill(trailing);
        g2.setColor(new Color(250, 250, 250, 100));
        g2.draw(leading);
        g2.draw(trailing);
        g2.setColor(Color.lightGray);
        if (this.tickNumber != 0 && this.setTicks) {
            Shape ticks = this.reformTicks(this.blueprint);
            g2.draw(ticks);
        }
        if (this.startMark) {
            g2.setColor(Color.white);
            Font font = new Font("Dialog", 0, 8);
            FontMetrics metrics = this.getFontMetrics(font);
            int textWidth = metrics.stringWidth(this.startMarkLabel);
            g2.setFont(font);
            g2.drawString(this.startMarkLabel, this.convertToPixels(this.thumbStart) - textWidth / 2, (int)((double)this.blueprint.trackBottom * 1.7));
        }
        g2.setColor(Color.lightGray);
        g2.fill(thumb);
        g2.setColor(Color.darkGray);
        g2.fill(miniThumb);
        g2.setColor(this.thumbColor);
        g2.draw(thumb);
    }

    private int getThumbX() {
        int i = this.right - this.left;
        return this.blueprint.closeTrackEdgeLeft + (this.value - this.left) * (this.blueprint.closeTrackEdgeRight - this.blueprint.closeTrackEdgeLeft) / (i == 0 ? 1 : i);
    }

    private int convertToAbstract(int value) {
        float i = this.blueprint.closeTrackEdgeRight - this.blueprint.closeTrackEdgeLeft;
        return this.left + Math.round((float)((value - this.blueprint.closeTrackEdgeLeft) * (this.right - this.left)) / (i == 0.0f ? 1.0f : i));
    }

    private int convertToPixels(int value) {
        float i = this.right - this.left;
        return this.blueprint.closeTrackEdgeLeft + Math.round((float)((value - this.left) * (this.blueprint.closeTrackEdgeRight - this.blueprint.closeTrackEdgeLeft)) / (i == 0.0f ? 1.0f : i));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int thumbX = this.getThumbX();
        if (Math.abs(e.getX() - thumbX) < this.getHeight() / 2) {
            this.offset = e.getX() - thumbX;
        } else {
            this.offset = 0;
            this.setValue(this.convertToAbstract(e.getX()));
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.setValue(this.convertToAbstract(e.getX() - this.offset));
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int xPos = this.convertToAbstract(e.getX() - this.offset);
        if (this.setTicks) {
            this.stickTicks(xPos);
        } else {
            this.setValue(xPos);
        }
        this.offset = 0;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public void stickTicks(int mouseReleaseXPos) {
        int xPos = mouseReleaseXPos;
        int total = this.right - this.left;
        int interval = total / this.tickNumber;
        int remain = xPos % interval;
        xPos = xPos >= this.right ? this.right : (xPos <= this.left ? this.left : (remain != 0 ? (remain <= interval / 2 ? (Math.abs(this.thumbStart - xPos) < interval - remain || xPos < this.thumbStart && xPos - remain > this.thumbStart && xPos + interval > this.thumbStart ? this.thumbStart : (xPos -= remain)) : (Math.abs(this.thumbStart - xPos) < interval - remain || xPos < this.thumbStart && xPos + (interval - remain) > this.thumbStart && xPos + interval > this.thumbStart ? this.thumbStart : (xPos += interval - remain))) : (remain == 0 ? mouseReleaseXPos : this.thumbStart)));
        this.setValue(xPos);
    }
}

