/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CHoverScrollPane;
import edu.mit.blocks.codeblockutil.CScrollPane;
import edu.mit.blocks.codeblockutil.Canvas;
import edu.mit.blocks.codeblockutil.StackExplorer;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

class StackCard
implements PropertyChangeListener {
    private int buttonHeight = 30;
    private Canvas canvas;
    private CardPane drawerPane;
    private StackExplorer explorer;
    private final int partitions = 5;
    private int dx;
    private int dy;
    private int dw;
    private int dh;
    private int count;
    private Rectangle origin;
    private Rectangle destination;
    private boolean directedToDestination;

    StackCard(Canvas canvas) {
        this(canvas, null);
    }

    StackCard(Canvas canvas, StackExplorer explorer) {
        if (canvas == null || canvas.getName() == null || canvas.getJComponent() == null) {
            throw new RuntimeException("Parameters may not be null");
        }
        this.canvas = canvas;
        this.explorer = explorer;
        this.drawerPane = new CardPane();
        if (this.drawerPane == null) {
            throw new RuntimeException("May not pass in a null instance of drawerPane");
        }
        this.directedToDestination = false;
        this.count = 0;
        this.origin = this.drawerPane.getBounds();
        this.destination = this.drawerPane.getBounds();
        this.dx = 0;
        this.dy = 0;
        this.dw = 0;
        this.dh = 0;
        canvas.getJComponent().addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("label_change_property")) {
            this.drawerPane.repaint();
        }
    }

    private void notifySelection() {
        if (this.explorer != null) {
            this.explorer.notifySelection(this, !this.directedToDestination);
        }
    }

    boolean isDirectedToDestination() {
        return this.directedToDestination;
    }

    void setBounds(Rectangle r) {
        this.drawerPane.setBounds(r);
    }

    void setBounds(int x, int y, int width, int height) {
        this.drawerPane.setBounds(x, y, width, height);
    }

    Rectangle getDestination() {
        return this.destination;
    }

    Rectangle getOrigin() {
        return this.origin;
    }

    JComponent getJComponent() {
        return this.drawerPane;
    }

    void reformDrawer(Rectangle origin, Rectangle destination) {
        this.origin = origin;
        this.destination = destination;
        this.dx = (destination.x - origin.x) / 5;
        this.dy = (destination.y - origin.y) / 5;
        this.dw = (destination.width - origin.width) / 5;
        this.dh = (destination.height - origin.height) / 5;
    }

    void goToOrigin() {
        this.directedToDestination = false;
    }

    void goToDestination() {
        this.directedToDestination = true;
    }

    void animate() {
        if (this.count < 0 || this.count > 5) {
            System.err.println("StackCard may not grow or move beyond theboundaries set by the origin and destination bounds");
        } else {
            int x = this.origin.x + this.dx * this.count;
            int y = this.origin.y + this.dy * this.count;
            int w = this.origin.width + this.dw * this.count;
            int h = this.origin.height + this.dh * this.count;
            this.drawerPane.setBounds(x, y, w, h);
            this.drawerPane.revalidate();
            if (this.directedToDestination) {
                if (this.count != 5) {
                    ++this.count;
                }
            } else if (this.count != 0) {
                --this.count;
            }
        }
    }

    private class CardLabel
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 3489589234L;
        private final int[][] shadowPositionArray;
        private final float[] shadowColorArray;
        private double offsetSize;

        private CardLabel() {
            int[][] nArrayArray = new int[9][];
            int[] nArray = new int[2];
            nArray[1] = -1;
            nArrayArray[0] = nArray;
            nArrayArray[1] = new int[]{1, -1};
            int[] nArray2 = new int[2];
            nArray2[0] = -1;
            nArrayArray[2] = nArray2;
            int[] nArray3 = new int[2];
            nArray3[0] = 2;
            nArrayArray[3] = nArray3;
            nArrayArray[4] = new int[]{-1, 1};
            nArrayArray[5] = new int[]{1, 1};
            int[] nArray4 = new int[2];
            nArray4[1] = 2;
            nArrayArray[6] = nArray4;
            int[] nArray5 = new int[2];
            nArray5[0] = 1;
            nArrayArray[7] = nArray5;
            int[] nArray6 = new int[2];
            nArray6[1] = 1;
            nArrayArray[8] = nArray6;
            this.shadowPositionArray = nArrayArray;
            this.shadowColorArray = new float[]{0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.0f, 0.0f};
            this.offsetSize = 1.0;
            this.setOpaque(false);
            this.setBorder(null);
            this.setFont(new Font("Ariel", 1, StackCard.this.buttonHeight - 3));
            this.setPreferredSize(new Dimension(0, StackCard.this.buttonHeight));
            this.setCursor(new Cursor(12));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StackCard.this.notifySelection();
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color highlight = StackCard.this.canvas.getHighlight();
            if (highlight == null) {
                g2.setColor(StackCard.this.canvas.getColor());
            } else {
                g2.setColor(highlight);
            }
            g2.fillRoundRect(0, 0, this.getWidth() - 2, 2 * this.getHeight(), this.getHeight(), this.getHeight());
            if (highlight == null) {
                g2.setStroke(new BasicStroke(2.0f));
                g2.setColor(new Color(255, 255, 255, 100));
            } else {
                g2.setStroke(new BasicStroke(2.0f));
                g2.setColor(new Color(0, 0, 0, 100));
            }
            g2.drawRoundRect(0, 0, this.getWidth() - 2, 2 * this.getHeight(), this.getHeight(), this.getHeight());
            String text = StackCard.this.canvas.getName();
            if (text != null) {
                Font font = g2.getFont().deriveFont((float)((double)this.getHeight() * 0.4));
                g2.setFont(font);
                FontMetrics metrics = g2.getFontMetrics();
                Rectangle2D textBounds = metrics.getStringBounds(text, g2);
                float x = (float)((double)(this.getWidth() / 2) - textBounds.getWidth() / 2.0);
                float y = (float)((double)(this.getHeight() / 2) + textBounds.getHeight() / 2.0) - (float)metrics.getDescent();
                g.setColor(Color.black);
                int i = 0;
                while (i < this.shadowPositionArray.length) {
                    int dx = this.shadowPositionArray[i][0];
                    int dy = this.shadowPositionArray[i][1];
                    g2.setColor(new Color(0.5f, 0.5f, 0.5f, this.shadowColorArray[i]));
                    g2.drawString(text, x + (float)((int)((double)(4 + dx) * this.offsetSize)), y + (float)((int)((double)(dy - 6) * this.offsetSize)));
                    ++i;
                }
                if (highlight == null) {
                    g2.setColor(Color.white);
                } else {
                    g2.setColor(highlight);
                }
                g2.drawString(text, x + (float)((int)(4.0 * this.offsetSize)), y + (float)((int)(-6.0 * this.offsetSize)));
            }
        }
    }

    private class CardPane
    extends JPanel {
        private static final long serialVersionUID = 49283583495L;
        private CScrollPane scroll;
        private CardLabel label;

        private CardPane() {
            super(new BorderLayout());
            this.setOpaque(false);
            this.scroll = new CHoverScrollPane(StackCard.this.canvas.getJComponent(), CScrollPane.ScrollPolicy.VERTICAL_BAR_AS_NEEDED, CScrollPane.ScrollPolicy.HORIZONTAL_BAR_AS_NEEDED, 18, StackCard.this.canvas.getColor(), new Color(100, 100, 100, 100));
            this.label = new CardLabel();
            this.add((Component)this.label, "North");
            this.add((Component)this.scroll, "Center");
        }
    }
}

