/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.renderable;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.renderable.BlockControlLabel;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.Workspace;
import java.awt.event.MouseEvent;

class CollapseLabel
extends BlockControlLabel {
    private static final long serialVersionUID = 1L;

    CollapseLabel(Workspace workspace, long blockID) {
        super(workspace, blockID);
    }

    @Override
    public void update() {
        RenderableBlock rb = this.workspace.getEnv().getRenderableBlock(this.getBlockID());
        if (rb != null) {
            int x = 0;
            int y = 0;
            y = (int)((double)y + ((double)rb.getBlockHeight() / rb.getZoom() - 22.0 + (double)(this.isActive() ? 4.0f : 0.0f)));
            x += 12;
            x = rb.rescale(x);
            y = rb.rescale(y);
            this.setLocation(x, y);
            this.setSize(rb.rescale(14), rb.rescale(14));
            if (this.isActive()) {
                this.setText("+");
            } else {
                this.setText("-");
            }
        }
    }

    void collapseBlockAndStack() {
        this.updateCollapse();
    }

    void updateCollapse() {
        RenderableBlock rb = this.workspace.getEnv().getRenderableBlock(this.getBlockID());
        if (rb != null) {
            this.collapseAfterBlocks(rb.getBlockID());
            rb.repaintBlock();
            if (rb.getHighlightHandler() != null) {
                rb.getHighlightHandler().updateImage();
                if (rb.getHighlightHandler().getParent() != null && rb.getHighlightHandler().getParent().getParent() != null) {
                    rb.getHighlightHandler().getParent().getParent().repaint();
                }
            }
        }
    }

    void collapseAfterBlocks(long blockID) {
        Block block = this.workspace.getEnv().getBlock(blockID);
        if (block.getAfterBlockID() != Block.NULL) {
            do {
                block = this.workspace.getEnv().getBlock(block.getAfterBlockID());
                this.collapseBlock(block.getBlockID());
            } while (block.getAfterBlockID() != Block.NULL);
        }
    }

    void collapseBlock(long blockID) {
        RenderableBlock rBlock = this.workspace.getEnv().getRenderableBlock(blockID);
        rBlock.setVisible(!this.isActive());
        if (rBlock.hasComment() && rBlock.getComment().getCommentLabel().isActive()) {
            rBlock.getComment().setVisible(!this.isActive());
        }
        rBlock.getHighlightHandler().updateImage();
        rBlock.repaintBlock();
        this.collapseSockets(blockID);
    }

    void collapseSockets(Long block_id) {
        Block block = this.workspace.getEnv().getBlock(block_id);
        for (BlockConnector socket : block.getSockets()) {
            if (socket.getBlockID() == Block.NULL) continue;
            this.collapseBlock(socket.getBlockID());
            this.collapseAfterBlocks(socket.getBlockID());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.toggle();
        this.collapseBlockAndStack();
        this.update();
    }
}

